using System;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.ComponentModel;
using System.Xml.Serialization;
using System.Security;
using System.Security.Permissions;
using Microsoft.SharePoint;
using Microsoft.SharePoint.Utilities;
using Microsoft.SharePoint.WebPartPages;
using Microsoft.SharePoint.WebPartPages.Communication;

namespace EasyTabParts
{
	/// <summary>
	///   This web part implements the ICellConsumer interface.
	///   Summary description for ShowCell.
	/// </summary>

	public abstract class EasyStringConsumer : Microsoft.SharePoint.WebPartPages.WebPart , ICellConsumer
	{
		private string receivedValue = "";
		protected string GetInputString()
		{
			return (receivedValue);
		}

		#region Web Part Connection logic and ICellConsumer Implementation
		/// <summary>
		///	 Events required by ICellConsumer
		/// </summary>
		public event CellConsumerInitEventHandler CellConsumerInit;

		/// <summary>
		///  Private variables to tell us whether we are connected.
		/// </summary>
		private int _cellConnectedCount = 0; //Keep a count of ICellConsumer connections

		/// <summary>
		//	 Cell Interface member variables
		/// </summary>
		private string _cellName = "Cell Data"; //Cell information
		
		/// <summary>
		/// EnsureInterfaces
		///----Notification to the Web Part that is should ensure that all
		///----its interfaces are registered using RegisterInterface.
		/// </summary>
		public override void EnsureInterfaces()
		{
			try
			{
				//Register the ICellConsumer interface
				RegisterInterface("CellConsumer_WPQ_",		//InterfaceName: Unique name of the interface

					"ICellConsumer",							//InterfaceType: The type of the interface

					WebPart.UnlimitedConnections,				//MaxConnections: sets how many connections can be formed on this interface

					ConnectionRunAt.Server,						//RunAtOptions: where the connection created can be run

					this,										//InterfaceObject: reference to the actual object that implements this interface

					"CellConsumer_WPQ_",						//InterfaceClientReference: for client-side connections, a string that is used as the identifier for the client-side
					//object that implements this interface.

					"Cell Consumer",							//MenuLabel: a general label for the interface
					//(used in Authoring Connections)

					"Consumes a cell of data");					//Description: an extended explanation of the
			}												//interface (used in Authoring Connections)
			catch(SecurityException e)
			{
				this.HandleError(e.Message);
			}
		}

		/// <summary>
		/// CanRunAt
		///----Called by the framework to determine whether a part thinks
		///----that it can be run on the client or server based on the current
		///----configuration.
		/// </summary>
		/// 
		public override ConnectionRunAt CanRunAt()
		{
			//This Web Part can run on server
			return ConnectionRunAt.Server;
		}

		/// <summary>
		/// PartCommunicationConnect
		///----Notification to the Web Part that it has been connected.  The
		///----framework uses this to inform a part that it is connected as
		///----soon as it connects up the appropriate events for the connection.
		/// </summary>
		/// <param name="interfaceName">Unique name of the interface that is being connected</param>
		/// <param name="connectedPart">Reference to the other Web Part that is being connected to</param>
		/// <param name="connectedInterfaceName">Unique name of the interface on the other Web Part</param>
		/// <param name="runAt">Where the interface should execute</param>
		/// 
		public override void PartCommunicationConnect(string interfaceName,
			WebPart connectedPart,
			string connectedInterfaceName,
			ConnectionRunAt runAt)
		{
			//Must be a server-side part so need to create the Web Part's controls
			EnsureChildControls(); 

			//Check if this is my particular cell interface
			if (interfaceName == "CellConsumer_WPQ_")
			{
				//Keep a count of the connections
				_cellConnectedCount++;
			}
		}

		/// <summary>
		/// PartCommunicationInit
		///----At this time, a part should fire any events that end with 'Init'
		///----if they can.
		///----## ICellConsumer Example: fire "CellConsumerInit"
		/// </summary>
		public override void PartCommunicationInit()
		{
			//If the connection wasn't actually formed then don't want to send Init event
			if(_cellConnectedCount > 0)
			{
				//If there is a listener, send init event
				if (CellConsumerInit != null)
				{
					//Need to create the args for the CellConsumerInit event
					CellConsumerInitEventArgs cellConsumerInitArgs = new CellConsumerInitEventArgs();
					
					//Set the FieldName
					cellConsumerInitArgs.FieldName = _cellName;
					
					//Fire the CellConsumerInit event.
					//This basically tells the Provider Web Part what type of
					//cell the Consuemr is expecting in the CellReady event.
					CellConsumerInit(this, cellConsumerInitArgs);
				}
			}
		}

		/// <summary>
		///GetInitArgs
		///----The GetInitArgs method is called by the Authoring environment for all
		///-----the initial data required for creating a connection.  It is a virtual
		///-----method on the WebPart base class which needs to be overridden by the
		///-----developer.  The method returns the InitArgs object and takes in the
		///-----interface name.
		/// </summary>
		/// <param name="interfacename">Name of interface that the framework is
		/// requesting information on</param>
		/// <returns>An EventArgs object such as CellProviderInitArgs</returns>
		public override InitEventArgs GetInitEventArgs(string interfaceName)
		{
			//Check if this is my particular cell interface
			if (interfaceName == "CellConsumer_WPQ_")
			{
				EnsureChildControls();

				//Need to create the args for the CellConsumerInit event
				CellConsumerInitEventArgs cellConsumerInitArgs = new CellConsumerInitEventArgs();
					
				//Set the FieldName
				cellConsumerInitArgs.FieldName = _cellName;
					
				//return the InitArgs
				return(cellConsumerInitArgs);
			}
			else
			{
				return(null);
			}
		}

		/// <summary>
		/// The CellProviderInit event handler.
		/// The Provider part will fire this event during its PartCommunicationInit phase
		/// </summary>
		/// <param name="sender">Provider Web Part</param>
		/// <param name="cellProviderInitArgs">The args passed by the Provider</param>
		public void CellProviderInit(object sender, CellProviderInitEventArgs cellProviderInitArgs)
		{
			//This is where the Consumer part could see what type of "Cell" the Provider
			//will be sending.
			//For this code example, nothing needs to be done here
		}

		/// <summary>
		/// The CellReady event handler.
		/// The Provider part will fire this event during its PartCommunicationMain phase
		/// </summary>
		/// <param name="sender">Provider Web Part</param>
		/// <param name="cellReadyArgs">The args passed by the Provider</param>
		public void CellReady(object sender, CellReadyEventArgs cellReadyArgs)
		{
			//Set the label text to the value of the "Cell" that was passed by the Provider
			if(cellReadyArgs.Cell != null)
			{
				receivedValue = cellReadyArgs.Cell.ToString();
			}
		}
		#endregion

		#region WebPart error rendering

		private bool errorSet = false;
		private string errorMessage = "";

		protected void HandleError (string message)
		{
			errorSet = true;
			errorMessage = message;
		}

		protected override void RenderWebPart(HtmlTextWriter output)
		{
			if (!errorSet)
			{
				base.RenderWebPart(output);
			}
			else
			{
				output.Write(SPEncode.HtmlEncode(errorMessage));
			}
		}
		#endregion
	}
}
